function walk(node) {
  let child, next;

  switch (node.nodeType) {
    case 1: // Element
    case 9: // Document
    case 11: // Document fragment
      child = node.firstChild;
      while (child) {
        next = child.nextSibling;
        walk(child);
        child = next;
      }
      break;

    case 3: // Text node
      handleText(node);
      break;
  }
}

function handleText(textNode) {
  let text = textNode.nodeValue;

  text = text.replace(/waterloo/gi, function(match) {
    // preserve capitalization
    if (match === match.toUpperCase()) return "WATERPOO";
    if (match[0] === match[0].toUpperCase()) return "Waterpoo";
    return "waterpoo";
  });

  textNode.nodeValue = text;
}

walk(document.body);
