public interface BinaryTreeInterface {

    /** 
     * Data: labelled binary trees, recursively defined as either the
     * empty tree, or the nonempty tree consisting of a root, a left
     * subtree and a right subtree.
     */

    public boolean isEmpty();
    // Determines whether the tree is empty
    // Precondition: None.
    // Postcondition: Returns true if the tree is empty;
    // otherwise returns false.

    public void makeEmpty();
    // Removes all nodes from the tree.
    // Precondition: None.
    // Postcondition: Tree is empty.

    public Object getRootItem() throws TreeException;
    // Retrieves the value in the root node.
    // Precondition: This is not the empty tree.
    // Postcondition: The value stored in the root node is 
    //                returned.  (The tree is unchanged.)
    // Exception: Throws TreeException if the tree is empty.

    public void setRootItem(Object newItem);
    // Changes the value at the root.
    // Precondition: None.
    // Postcondition: The value at the root is replaced by newItem
    //   If the tree is empty, creates a root node with the value
    //   newItem and with no subtrees.

    public void attachLeft(Object newItem);
    // Appends a node as the left subtree
    // Precondition: This is not the empty tree.
    // Postcondition: If the tree has empty left subtree,
    //   then replaces it by a left subtree consisting
    //   of a single node only, with value newItem.  
    //   Otherwise the tree is unchanged.

    public void attachRight(Object newItem);
    // Appends a node as the right subtree
    // Precondition: This is not the empty tree.
    // Postcondition: If the tree has empty right subtree,
    //   then replaces it by a right subtree consisting
    //   of a single node only, with value newItem.  
    //   Otherwise the tree is unchanged.

    public void attachLeftSubtree(BinaryTreeInterface leftTree) 
        throws TreeException;
    // Appends a pre-formed tree as the left subtree
    // Precondition: This is not the empty tree, but 
    //    the left subtree is an empty tree. 
    //    newTree is not a proper subtree of any tree
    //    nor is its root an ancestor of the root of this.
    // Postcondition: newTree is appended as the left subtree.
    //    newTree itself is made empty.
    // Exception: Throws TreeException if this is empty
    //    or if the left subtree is not empty
    //    or if newTree is not independent.

    public void attachRightSubtree(BinaryTreeInterface rightTree) 
        throws TreeException;
    // Appends a pre-formed tree as the right subtree
    // Precondition: This is not the empty tree, but 
    //    the right subtree is an empty tree. 
    //    newTree is not a proper subtree of any tree
    //    nor is its root an ancestor of the root of this.
    // Postcondition: newTree is appended as the right subtree.
    //    newTree itself is made empty.
    // Exception: Throws TreeException if this is empty
    //    or if the right subtree is not empty
    //    or if newTree is not independent.

    public BinaryTreeInterface detachLeftSubtree() 
        throws TreeException;
    // Detaches the right subtree
    // Precondition: This is not empty.
    // Postcondition: The left subtree is returned as a separate  
    //    tree and the left subtree is made empty.
    // Exception: Throws TreeException if this is empty.

    public BinaryTreeInterface detachRightSubtree() 
        throws TreeException;
    // Detaches the right subtree
    // Precondition: This is not empty.
    // Postcondition: The right subtree is returned as a separate 
    //   tree and the right subtree is made empty.
    // Exception: Throws TreeException if this is empty.

} // end BinaryTreeInterface
