public class PolynomialTester
{
  // A non-exhaustive set of tests to help you debug your code.  
  // Add/change these tests, but you are not submitting any code found in here
  
  public static void main( String[] args )
  {
    // Make a new zero polynomial
    System.out.print( "Create a zero polynomial and print it. \nExpect: 0\nActual: " );
    Polynomial a = new Polynomial( 100 );
    System.out.println( a );
    
    // Make it the polynomial given at the start of the assignment
    System.out.print( "\nSet coefficients to example in assignment and print it. \nExpect: " +
                      "+7x^5 -12x^3 +1x +3\nActual: " );
    a.setCoeff(0,3);
    a.setCoeff(1,1);
    a.setCoeff(5,7);
    a.setCoeff(3,-12);
    System.out.println( a );
    
    // Get its degree
    System.out.print( "\nPrint degree of that polynomial. \nExpect: 5\nActual: " );
    System.out.println( a.getDegree() );
    
    // Evaluate at x=2
    System.out.print( "\nEvaluate polynomial at x=2. \nExpect: 133\nActual: " );
    System.out.println( a.eval(2) );
    
    // Add the two polynomials given in the assignment
    System.out.print( "\nPerform addition example in assignment\nExpect: " +
                      "+13x^4 +9x +4\nActual: " );
    Polynomial e = new Polynomial( 100 );
    e.setCoeff(4,6);
    e.setCoeff(2,2);
    e.setCoeff(0,4);    
    Polynomial f = new Polynomial( 100 );
    f.setCoeff(1,9);
    f.setCoeff(2,-2);
    f.setCoeff(4,7);
    e.add(f);
    System.out.println( e );
    
    // Ensure other polynomial is unchanged
    System.out.print( "\nEnsure addition did not modify the second polynomial\nExpect: " +
                      "+7x^4 -2x^2 +9x\nActual: " );
    System.out.println( f );
    
    // Multiply the two polynomials given in the assignment
    System.out.print( "\nPerform multiplication example in assignment\nExpect: " +
                      "+2x^3 +2x^2 -2x -20\nActual: " );
    Polynomial c = new Polynomial( 100 );
    c.setCoeff(1,2);
    c.setCoeff(0,-4);  
    Polynomial d = new Polynomial( 100 );
    d.setCoeff(2,1);
    d.setCoeff(1,3);
    d.setCoeff(0,5);
    c.multiply(d);  
    System.out.println( c );
    
    // Ensure other polynomial is unchanged
    System.out.print( "\nEnsure multiplication did not modify the second polynomial\nExpect: " +
                      "+1x^2 +3x +5\nActual: " );
    System.out.println( d );
  }
}