public class Book extends LibraryItem
{
  // One type of LibraryItem, a book.  In addition to everything a LibraryItem
  // can do, this class has extra instance variables/methods specific to a book
  
  // Instance variables for the author, the number of pages, and what genre
  // the book belongs to
  private String author;
  private String genre;
  private int numPages;
  
  // pre:  title, author, genre != null;    pages, year > 0
  // post: Initializes all the instance variables for a new Book
  public Book( String title, int year, int pages, String author, String genre )
  {
    super( title, year );
    this.numPages = pages;
    this.author = author;
    this.genre = genre;
  }
  
  // post: returns the number of pages the book has
  public int getNumPages()
  {
    return this.numPages;
  }
  
  // pre:  area != null
  // post: returns true if area is the same as this book's genre
  public boolean isInGenre( String area )
  {
    return this.genre.equals( area );
  }
  
  // post: returns a string.  The first three lines contain 
  //       the availability, title, #pages and year published.
  //       On the fourth line the author appears
  public String toString()
  {
    String output = super.toString();
    
    output += "\n" + author;
    
    return output;
  }
}
