public class Game
{
  // A class to manage the rules and display of a flipper game
  
  // Define your constants here
  
  
  // The instance variables (you may add more)
  private Board pegBoard;  // A 2-D board which shows where the pegs are
  private int[][] pegs;    // A record of what is in each square on the board
  private int turn;        // The number of the player whose turn it is currently 
                           // (should always be 1 or 2)
  
  // pre:  size > 0
  // post: The constructor will create a square board of the given size, and a 
  //       square, 2-D array of the given size.  The array and board are initialized so 
  //       the top left/right squares belong to player one and the bottom left/right 
  //       squares belong to player two.  The game will start with player one making 
  //       the first move.  
  public Game(int size)
  {
    // Unimplementend
  }
  
  // pre:  size > 0, squares != null
  // post: In addition to doing the same work as the previous constructor, this 
  //       constructor takes a one dimensional array of Coordinates that specify 
  //       squares that are unusable.  It is assumed that all of the coordinates 
  //       in the array are valid positions on the board, and do not correspond to 
  //       one of the four corners.
  public Game(int size, Coordinate[] squares)
  { 
    // Unimplemented
    
    // If you do not choose to implemented the variation of the rules with
    // unusable squares, then you do not need to bother with this method.
  }
  
  // pre:   The array is initialized, and the board has been created and is
  //        currently displaying the starting configuration of the game.
  // post:  The game is over
  //
  // Note:   Read the assigment specifications for more details on how the game
  //         is played, but this method has already been completed for you.
  //
  // DO NOT MODIFY THE CONTENTS OF THIS METHOD
  public void playGame()
  {    
    // Players take turns until someone cannot make a valid move
    while( !this.isGameOver() )
    {
      // Get next Player's move
      Coordinate spot = this.getValidMove();
      
      // Perform the move
      this.performMove( spot );
      
      // Update the board
      this.drawBoard();
    }
    
    // Display a message about the end of the game.
    this.displayFinalMessage();
  }
  
  // pre:  The board and array have been created
  // post: Update the display of the pegs on the board to reflect the 
  //       current state of the game stored in the array.
  private void drawBoard()
  { 
    // Unimplemented
  }
  
  // post: Returns true if there are no squares left where the current player 
  //       would be able to place a peg.  Returns false if at least one square
  //       on the board is a valid move for the current player.
  private boolean isGameOver()
  { 
    // Unimplemented.  You need to change the following line of code
    
    return false;
  }
  
  // pre:  the game is not over
  // post: Displays a message on the board for the current player to
  //       select a square, and waits for the user to click on the board.   
  //       If the user selected a square that is not a valid move the
  //       board displays an error, and the player is forced to select again
  //       until a valid square is selected.
  //       The coordinate for this valid move is returned.
  //
  // Note:   This method has already been completed for you.
  //
  // DO NOT MODIFY THE CONTENTS OF THIS METHOD
  private Coordinate getValidMove()
  {
    // Read in a mouse click
    this.pegBoard.displayMessage("Player " + this.turn + " select a square" );
    Coordinate square = pegBoard.getClick();
    
    // See if the square is valid for the current player
    while( !this.isValidMove( square.getRow(), square.getCol() ) )
    {
      // Display an error and try again
      this.pegBoard.displayMessage("Invalid move!  Player " + this.turn + " select another square" );
      square = pegBoard.getClick();
    }
    
    // Return the location of the move
    return square;
  }

  // pre:  move is a valid square that the current player can place a peg
  // post: The pegs array is updated so that a peg of the current players colour 
  //       is placed in move's location.  As well, all opponent pegs that are 
  //       adjacent to move's location change colour.  Finally the game's state is
  //       updated so that it is now the other persons turn. 
  //
  // Note: The board is not updated by this method
  private void performMove( Coordinate move )
  {
    // Unimplemented
  }
  
  // pre:  the game is over
  // post: displays a message on the board indicating which player won, and
  //       what the score was.  If the game is tied an appropriate message 
  //       is displayed.
  //
  // Note:   This method has already been completed for you.
  //
  // DO NOT MODIFY THE CONTENTS OF THIS METHOD
  private void displayFinalMessage()
  { 
    // Get the scores of the two players
    int score1 = this.numPegs( 1 );
    int score2 = this.numPegs( 2 );
    
    // Build the final message
    String msg = "Game over: ";
    
    // See if it is a tie
    if (score1 == score2)
    { 
      msg += "TIE GAME";
      
    // Print out who won along with the score
    } else if ( score1 > score2 )
    { 
      msg += "Player 1 won (" + score1 + "-" + score2 + ")";
    } else 
    { 
      msg += "Player 2 won (" + score2 + "-" + score1 + ")";
    }
    
    // Put the message on the board
    this.pegBoard.displayMessage(msg);
  }

  // pre:  row and col are within the confines of the board
  // post: Returns true if the indicated square is empty and at least one
  //       of the adjacent squares contains a peg of the current player's
  //       colour.  Returns false otherwise.
  private boolean isValidMove( int row, int col )
  {
    // Unimplemented.  You need to change the following line of code
    
    return true;
  }
  
  // pre:  player == 1 or player == 2
  // post: returns the number of squares on the board with pegs of that player's colour
  private int numPegs( int player )
  {
    // Unimplemented.  You need to change the following line of code
    
    return -1;
  }
  
  // Declare any other helper methods down here
  
}
