import java.util.Scanner;

/** 
 * The starting point for the flipper game that allows for
 * the unusable squares variant.  
 */
public class GameVariationDriver
{
  /** 
   * The main method of your program.  It reads in the 
   * board size from the user, and a list of unusable 
   * squares from the user, and then creates and runs 
   * the game. 
   */
  public static void main( String[] args )
  { 
    // Input the size of the board
    Scanner in = new Scanner(System.in);
    System.out.println("Enter board size");  
    int size = in.nextInt();
    
    // Ensure it is positive
    if ( size <= 0 )
    {
      System.out.println( "Board size must be postive." );
      return;
    }
    
    // Input the number of unusable squares
    System.out.println("Enter number of ununsable squares");
    int numUnusable = in.nextInt();
    
    // Ensure it is non-negative
    if ( size < 0 )
    {
      System.out.println( "Cannot have a negative number of unusable squares." );
      return;
    }
    
    // Read in the coordinates for each of the unusable squares into an array
    // We blindly assume that none of the corners are going to be selected
    Coordinate[] squares = new Coordinate[numUnusable];
    for( int i=0; i<numUnusable; i++ )
    {
      System.out.println("Enter row and column of next unusable square");
      int row = in.nextInt();
      int col = in.nextInt();
      
      // We do ensure the coordinate at least exists on the board
      if( row < 0 || row >= size || col < 0 || col >= size )
      {
        System.out.println( "Invalid coordinate for given board size" );
        return;
      }
      
      // Add a new Coordinate to the array 
      squares[i] = new Coordinate( row, col );
    }
    
    // Create the game object
    Game flipper = new Game( size, squares );
    
    // Start the game
    flipper.playGame();
  }
}