public class Library
{
  // A class that maintains a list of items in the library that may be Journals or books
  
  // The only instance variable is an array containing the various LibraryItems
  private LibraryItem[] collection;
  
  // pre:  input != null
  // post: collection contains a copy of all of the items in the input array
  public Library( LibraryItem[] input )
  {
    this.collection = new LibraryItem[ input.length ];
    for (int i=0; i<input.length; i++)
    {
      this.collection[i] = input[i];
    }
  }
  
  // pre:  0 <= pos < collection.length, pos'th item in the collection is available
  // post: The pos'th item in the collection is signed out
  public void signOut( int pos )
  {
    this.collection[ pos ].signOutItem();
  }
  
  // pre:  0 <= pos < collection.length, pos'th item in the collection is signed out
  //       numDaysLate >= 0
  // post: The pos'th item in the collection is available, any overdue fines are printed out
  public void returnItem( int pos, int numDaysLate )
  {
    this.collection[ pos ].returnItem( numDaysLate );
  }
  
  // post: All the items in the library with more than numPages pages are printed out
  //       With a blank line between them.
  public void displayAllItemsOverLength( int numPages )
  {
    // Unimplemented
  }
  
  // pre:  genre != null
  // post: All the BOOKS in the library belonging to the genre are printed out
  //       With a blank line between them.
  public void displayAllBooksInGenre( String genre )
  {
    // Unimplemented
  }
  
  // pre:  month != null
  // post: All the JOURNALS in the library published in the given month are printed out
  //       With a blank line between them.
  public void displayAllJournalsInMonth( String month )
  {
    // Unimplemented
  }
}
