public class LibraryItem
{
  // A single item that can be checked out in the library
  
  // What a borrower of a typical item will be charged (per day) if it is returned late
  private static final double OVERDUE_RATE = 0.25;
  
  // Basic info about the item
  private String title;
  private int year;
  
  // Whether the item is in the library
  private boolean signedOut;
  
  // pre:  title != null, year > 0
  // post: the basic information is setup with the parameters, and the item is 
  //       not checked out
  public LibraryItem( String title, int year )
  {
    this.title = title;
    this.year = year;
    this.signedOut = false;
  }
  
  // post: The item is flagged as being unavailable 
  public void signOutItem()
  {
    this.signedOut = true;
  }
  
  // pre:  numDaysLate >= 0
  // post: The item is flagged as being unavailable.
  //       If item is returned late, prints out what the overdue fines are
  public void returnItem( int numDaysLate )
  {
    this.signedOut = false;
    if ( numDaysLate > 0 )
    {
      double fees = numDaysLate * this.calcDayFine();
      System.out.println( "Overdue fees: " + fees );
    }
  }
  
  // post: returns what the per day fine for the item is
  // 
  // Note: This method may be overridden if the item should have a different
  //       fine (perhaps because it is a reserved or special item).
  public double calcDayFine()
  {
    return this.OVERDUE_RATE;  
  }
  
  // post: returns how many pages the item has
  //
  // Note: This method may be overridden if the item actual contains pages
  //       (A CD or movie for instance will not override this method).
  public int getNumPages()
  {
    return 0;
  }
  
  // post: returns a string containing whether the item is available on the first line
  //       followed by a line containing the title and number of pages for the item
  //       followed by a line containing the year the item was published
  //
  // Note: This method will be overridden to also print out extra information
  //       (A movie for instance may print out actors in the movie).
  public String toString()
  {
    String output;
    
    if ( this.signedOut )
    {
      output = "Signed Out\n";
    } else 
    {
      output = "Available\n";
    }
    
    output += this.title + ", Pages: " + this.getNumPages() + "\n";
    output += this.year;
    
    return output;
  }
}