public class TestLibrary
{
  // A class to help you test the library, and Journal classes you wrote
  // You may change this file, but you are not submitting it.
  public static void main( String[] args )
  {
    // Make the collection of books to go in the library
    LibraryItem[] lib = new LibraryItem[7];
   
    Journal j = new Journal( "Journal of Math", 2007, "Jan", 2 );
    j.setArticle( 0, "All About e", 40 );
    j.setArticle( 1, "Four-sided Triangles?", 5 );
    lib[0] = j;
    
    j = new Journal( "Journal of Math", 2007, "Feb", 3 );
    j.setArticle( 0, "Why is pi Good?", 10 );
    j.setArticle( 1, "Reading the cosins", 20 );
    j.setArticle( 2, "Three-sided Squares?", 5 );
    lib[1] = j;
    
    lib[2] = new Book( "Programming Java", 2005, 500, "Savitch, Walter", "Computer Programming" );
    lib[3] = new Book( "Harry Potter and the Goblet of Fire", 2000, 734, "Rowling, J.K.", "Young Adult" );
      
    j = new Journal( "Journal of CS", 2007, "Feb", 2 );
    j.setArticle( 0, "Java is Better Than Scheme!", 400 );
    j.setArticle( 1, "Scheme is Better Than Java!", 400 );
    lib[4] = j;
    
    lib[5] = new Book( "Harry Potter and the Deathly Hallows", 2007, 784, "Rowling, J.K.", "Young Adult" );
    lib[6] = new Book( "Programming Scheme", 2006, 550, "Smith, John", "Computer Programming" );
  
    // Put the books in the library
    Library theLibrary = new Library( lib );
    
    // Sign out some books
    theLibrary.signOut( 0 );
    theLibrary.signOut( 2 );
    theLibrary.signOut( 3 );
    theLibrary.signOut( 4 );
    theLibrary.signOut( 5 );
    
    // Return a book ontime
    System.out.println( "Expect: <no output should appear>" );
    System.out.print( "Actual: " );
    theLibrary.returnItem( 2, 0 ); 
    
    // Return a book late
    System.out.println( "\n\nExpect: Overdue fees: 1.25" );
    System.out.print( "Actual: " );
    theLibrary.returnItem( 3, 5 );
    
    // Return a journal late
    System.out.println( "\nExpect: Overdue fees: 2.0" );
    System.out.print( "Actual: " );
    theLibrary.returnItem( 4, 2 );
    
    // Print all items over 525 pages
    System.out.println( "\nExpect: 4 items should be printed" );
    System.out.println( "Actual: " );
    theLibrary.displayAllItemsOverLength( 525 );
    
    // Print all books in young adult
    System.out.println( "\nExpect: 2 books should be printed" );
    System.out.println( "Actual: " );
    theLibrary.displayAllBooksInGenre( "Young Adult" );
    
    // Print all journals from the month of februrary
    System.out.println( "\nExpect: 2 journals should be printed" );
    System.out.println( "Actual: " );
    theLibrary.displayAllJournalsInMonth( "Feb" );
  }
}
