public class UsingFancyBoard {

    public static void main( String[] args ) {

        FancyBoard board = new FancyBoard( 7, 10 );

        // Make sure standard board drawing methods work
        board.putPeg( "red",   1, 1 );
        board.putPeg( "green", 1, 8 );
        board.putPeg( "blue",  5, 1 );
        board.drawLine( 0, 0, 0, 9 );
        board.drawLine( 6, 0, 6, 9 );

        // Test the drawRectangle(...) method
        Coordinate one = new Coordinate(2,2);
        Coordinate two = new Coordinate(4,7);
        board.drawRectangle( one, two );

        // Pause so you can admire the program's output...
        board.displayMessage( "Click anywhere to proceed." );
        Coordinate dummy = board.getClick();

        // Make sure standard erasing methods work
        board.removePeg( 1, 1 );
        board.removeLine( 0, 0, 0, 9 );
        board.removeLine( 6, 0, 6, 9 );

        // Test the removeRectangle(...) method
        board.removeRectangle( one, two );

        board.displayMessage( "The red peg, lines, & rectangle should be gone. Click again to quit." );
        board.getClick(); 

        // Force the program, including display of the board, to quit;
        // "0" is the convention for a "normal" exit, meaning that everything went ok. 
        System.exit(0);
    }
}
