/**
 * This class will define objects representing computer specifications.
 */

public class Computer
{
  private String brand;      // Keeps track of the brand of the computer
  private double cpuSpeed;   // Keeps track of the cpu speed
  private int RAM;           // Keep track of the RAM
  
  /**
   * The constructor
   * pre:  type != null, speed > 0, memory > 0
   * post: Sets the instance variables for the Computer object
   */
  public Computer(String type, double speed, int memory)
  { 
    this.brand = type;
    this.cpuSpeed = speed;
    this.RAM = memory;
  }
    
  /**
   * pre:  other != null
   * post: changes the other Computer to have the same speed as this Computer
   */
  public void makeSameSpeed(Computer other)
  {
    String oldBrand = other.brand;
    int oldRAM = other.RAM;
    other = new Computer(oldBrand, this.cpuSpeed, oldRAM); 
  }
  
  /**
   * pre:  none
   * post: doubles the speed of this Computer
   */
  public void doubleSpeed()
  {
    this.cpuSpeed = 2*this.cpuSpeed;
  }
  
  /**
   * pre:  other != null
   * post: returns true if the brands of the two Computers are the same
   */
  public boolean sameBrand(Computer other)
  {
    boolean same = (this.brand == other.brand);
    return same;
  }
      
  /**
   * pre:  none
   * post: returns the brand name (in upper case) of this Computer
   */
  public String getUpperBrand()
  {
    return this.brand.toUpperCase();
  }
  
  /**
   * pre:  other != null
   * post: returns true if this is the same computer as other, false otherwise
   */
  public boolean equals(Computer other)
  {
    return (this.cpuSpeed == other.cpuSpeed 
              && this.brand == other.brand 
              && this.RAM == other.RAM);
  }
    
  /**
   * pre:  none
   * post: returns a String representation of the computer
   */
  
  /*     // Remove this line after part a) of question 1
  public String toString()
  {
    String display = "Brand: brand\nSpeed: speed\nRAM: ram";
    return display;
  }
  */     // Remove this line after part a) of question 1
}

