
package monopoly.model;
import java.util.ArrayList;
import karel.util.IObserver;


/** A class representing one monopoly player.
@author Byron Weber Becker */
public abstract class Player extends Object
{  private ArrayList observers = new ArrayList();

   
   
   /** Get a list naming the properties this player has bought.
   @returns a full array giving the names of the properties owned by this player. */
   public String[] getOwnedPropertyNames()
   {  
    return null;
   }

   /** Get the name of this player
   @returns the name of this player */
   public String getName()
   {  
    return null;
   }

   /** Get the id of this player.
   @returns the id of this player */
   public int getID()
   {  
    return 0;
   }

   /** Get the bank balance of this player.
   @returns this player's bank balance */
   public int getBalance()
   {  
    return 0;
   }

   /** Get the net worth of this player.
   @returns this player's net worth */
   public int getNetWorth()
   {  
    return 0;
   }

   /** Indicate whether or not this player can buy the Square it most
   recently landed on.
   @returns true if the player can buy the Square; false otherwise */
   public boolean canBuyOccupiedSquare()
   {  
    return false;
   }

   

   /** Instruct this player to buy a house.
   @param propertyIndex buy the house for the property named by
      this.getOwnedSquareNames()[propertyIndex] */
   public void buyHouse(String propName)
   {  
   }
   

   /** Buy the Square most recently landed on by this player */
   public void buyOccupiedSquare()
   {  
   }

   /** Roll the dice and advance the token. */
   protected void advanceToken()
   {  
   }


   /** Advance the token the given number of properties.
   @param howFar how many properties to advance  */
   protected void advanceToken(int howFar)
   {  
   }

   /** Make a move for this player -- find out how far to advance
   the token, advance it, transact any resulting business such as
   paying rent or buying properties/houses.  Must be overridden in
   subclasses. */
   protected abstract void makeMove();

   /** Get the player's current position on the board.
   @return 0 for "Go, 1 for "Mediterrainean Ave", etc. */
   public int getBoardPosition()
   {  
 return 0;
   }

   

   /** Add a listener for changes to this player model.
   @param ml the monopoly listener to add */
   public void addObserver(IObserver ml)
   {  this.observers.add(ml);
   }

   /** Update the views that are listening to this model for changes
   @param model the model object that actually changed (usually 'this')
   @param changeInfo option info about what changed */
   protected void updateObservers(Object model, Object changeInfo)
   {  for(int i=0; i<this.observers.size(); i++)
      {  IObserver ob = (IObserver)this.observers.get(i);
         ob.update(model, changeInfo);
      }
   }

   /** Represent this object as a String.  Useful for debugging. */
   public String toString()
   {  return null;
   }
}
