
package monopoly.model;
import java.util.*;
import karel.util.IObserver;


/** A class representing one square on a monopoly board.  A Square can be a
building lot such as "Vermont Ave" or "Park Place".  It can also be a
railroad, "Go", Chance, the jail, and so on.
@author Byron Weber Becker */
public abstract class Square extends Object
{  private ArrayList observers = new ArrayList();
  

   public String getName()
   {  
    return null;
   }

   /** Get a description of this property
   @returns a description of this property */
   public String getDescription()
   {  
 return null;
   }

   

   /** Get a list of the players currently occupying this property.
   @returns a full array with the 0 or more players who have most recently
   landed on this property */
   public Player[] getPlayers()
   {  
    return null;
   }


   /** Represent this object as a String.  Useful for debugging. */
   public String toString()
   {  return null;
   }

   /** Add a listener for changes to this property model.
   @param ml the monopoly listener to add */
   public void addObserver(IObserver ml)
   {  this.observers.add(ml);
   }


   /** Update the views that are listening to this model for changes
   @param changedModel the model object that actually changed (usually 'this') */
   protected synchronized void updateObservers(Object model, Object changeInfo)
   {  for(int i=0; i<this.observers.size(); i++)
      {  IObserver ml = (IObserver)this.observers.get(i);
         ml.update(model, changeInfo);
      }
   }

}
