## print_triangle(size) prints a triangle with size rows.
## Effects: Prints to screen.
## print_triangle: Int -> None
## Requires: size >= 0
def print_triangle(rows):
    num_spaces = rows - 1  # number of spaces before first character
    num_chars = 1          # number of characters in a row of the triangle
    STAR = '*'             # the character used to draw the triangle
    
    for i in range(rows):
        print(" " * num_spaces + STAR * num_chars)
        num_spaces = num_spaces - 1
        num_chars = num_chars + 2

print_triangle(5)

## print_triangle_alt_one(size) prints a triangle with size rows.
## Effects: Prints to screen.
## print_triangle_alt_one: Int -> None
## Requires: size >= 0
def print_triangle_alt_one(rows):
    STAR = '*'             # the character used to draw the triangle

    for i in range(rows):
        print(" " * (rows - i - 1) + STAR * (2 * i + 1))

print_triangle_alt_one(5)

## print_triangle_alt_two(size) prints a triangle with size rows.
## Effects: Prints to screen.
## print_triangle_alt_two: Int -> None
## Requires: size >= 0
def print_triangle_alt_two(rows):
    num_spaces = rows - 1  # number of spaces before first character
    num_chars = 1          # number of characters in a row of the triangle
    STAR = '*'             # the character used to draw the triangle
    row = 0

    while row < rows:
        print(" " * num_spaces + STAR * num_chars)
        num_spaces = num_spaces - 1
        num_chars = num_chars + 2
        row = row + 1

print_triangle_alt_two(5)


## print_triangle_break(size) prints a triangle with size rows.
## Effects: Prints to screen.
## print_triangle_break: Int -> None
## Requires: size >= 0
def print_triangle_break(rows):
    num_spaces = rows - 1  # number of spaces before first character
    num_chars = 1          # number of characters in a row of the triangle
    STAR = '*'             # the character used to draw the triangle

    for i in range(rows):
        print(" " * num_spaces + STAR * num_chars)
        num_spaces = num_spaces - 1
        num_chars = num_chars + 2
        if num_chars == 5:
            break

print_triangle_break(5)
