import check
import math

## num_fives(my_int) produces the number of times the digit 5
##     occurs in my_int.
## num_fives: Int -> Int
## Requires: 0 <= my_int 
def num_fives(my_int):
    if my_int == 0:
      return 0
    elif my_int % 10 == 5:
       return 1 + num_fives(my_int // 10)
    else:
        return num_fives(my_int // 10)

check.expect("Base case 0", num_fives(0), 0)
check.expect("No fives", num_fives(34298769), 0)                 
check.expect("One five, at beginning", num_fives(534298769), 1)
check.expect("One five, at end", num_fives(342987695), 1)              
check.expect("One five, in middle", num_fives(342958769), 1)
check.expect("Multiple fives", num_fives(355242553345), 5)


## num_fives_alt(my_int) produces the number of times the digit 5
##     occurs in my_int.
## num_fives_alt: Int -> Int
## Requires: 0 <= my_int 
def num_fives_alt(my_int):
    if my_int == 0:
      return 0
    elif my_int % 10 == 5:
       return 1 + num_fives_alt(math.floor(my_int / 10))
    else:
        return num_fives_alt(math.floor(my_int / 10))

check.expect("Base case 0", num_fives_alt(0), 0)
check.expect("No fives", num_fives_alt(34298769), 0)                 
check.expect("One five, at beginning", num_fives_alt(534298769), 1)
check.expect("One five, at end", num_fives_alt(342987695), 1)              
check.expect("One five, in middle", num_fives_alt(342958769), 1)
check.expect("Multiple fives", num_fives_alt(355242553345), 5)



