import check
from sess2q2point import *

point_11 = Point(1, 1, "oneone")
point_13 = Point(1, 3, "onethree")
point_31 = Point(3, 1, "threeone")
point_33 = Point(3, 3, "threethree")
point_11_other = Point(1, 1, "notoneone")
point_11_twin = Point(1, 1, "oneone")

print("Tests for repr")

check.expect("print (1, 3)", repr(point_13), \
             "onethree: (1, 3)")
check.expect("print (3, 1)", repr(point_31), \
             "threeone: (3, 1)")

print("Tests for x_value")

check.expect("x_value of (1, 1)", point_11.x_value(), 1)
check.expect("x_value of (3, 1)", point_31.x_value(), 3)

print("Tests for y_value")

check.expect("y_value of (1, 1)", point_11.y_value(), 1)
check.expect("y_value of (1, 3)", point_13.y_value(), 3)

print("Tests for label")

check.expect("Label of (1, 1)", point_11.label(), "oneone")
check.expect("Label of (3, 3)", point_33.label(), "threethree")

print("Tests for same_place")

check.expect("Points in same place", point_11.same_place(point_11_other), True)
check.expect("Points with same x_value", point_11.same_place(point_13), False)
check.expect("Points with same y_value", point_11.same_place(point_31), False)
check.expect("Points with different values", \
             point_11.same_place(point_33), False)

print("Tests for equality")

check.expect("Equal points", point_11 == point_11_twin, True)
check.expect("Not equal points", point_11 == point_11_other, False)

print("Tests for dist")

check.within("Same point", point_11.dist(point_11), 0.0, .1)
check.within("Same x-values", point_11.dist(point_13), 2.0, .1)
check.within("Same y-values", point_11.dist(point_31), 2.0, .1)
check.within("Different values", point_11.dist(point_33), 2.83, .01)
