import check

## string_transform(text) produces what is formed from text by putting half
##     of each word on a separate line, followed by a question mark.
## string_transform: Str -> Str
def string_transform(text):
    word_list = text.strip().split()
    result = ""
    for word in word_list:
        mid = len(word) // 2
        result = result + word[:mid] + "?\n"
    return result

check.expect("No words", string_transform("               "), "")
check.expect("One even-length word", string_transform("     hi   "), "h?\n")
check.expect("One odd-length word", string_transform("   odd    "), "o?\n")
check.expect("Multiple words", string_transform("  this  is not   strange "), \
             "th?\ni?\nn?\nstr?\n")
    
