## make_points_text_file(num_points, points_string, file_name) creates
##     a new text file for a list of points  with the name formed by
##     concatenating "testpoints" and file_name, where the characters in
##     points_string form the x_value, y_value, and label of the num_points
##     points.
## Effects: Creates a new text file.
## make_points_text_file: Int Str Str -> None
## Requires: points_string contains single-digit integers in the
##     appropriate locations for x_value and y_value and is of length
##     3 * num_points
##     num_points > 0
def make_points_text_file(num_points, points_string,  file_name):
    # Creates a new text file.
    pointsfile = open("testpoints{0}.txt".format(file_name), 'w')

    # Creates a line with the number of points.
    pointsfile.write(str(num_points)+" \n")

    # Creates a line for each point.
    current = 0

    for row in range(num_points):
        row_string = points_string[current] + " " \
                     + points_string[current + 1] + " " \
                     + points_string[current + 2] + " \n"
        current = current + 3        
        pointsfile.write(row_string)                           

    pointsfile.close
