from linked import *
from sess2q2point import *

## make_points(fname) opens the file fname, reads in the lines with
##     the information given below, and produces a linked list of Points: 
##     - number of Points (one line)
##     - x_value, y_value, and label of a Point (three values per line)
## make_points: Str -> Single
def make_points(fname):
    data_file = open(fname, "r")
    data_list = data_file.readlines()[1:]
    data_file.close()
    
    data_list.reverse()
    
    current = None
    for line in data_list:
        data = line.strip().split()
        
        x_value = int(data[0])
        y_value = int(data[1])
        label = data[2]
        
        new_point = Point(x_value, y_value, label)
        current = Single(new_point, current)
    return current

