import check
from sess2q5makepointstextfile import *
from sess2q6makepointslist import *

make_points_text_file(6, "11a13b31c33d11e11a", "six")

my_points = make_points("testpointssix.txt")

first = my_points
second = first.next()
third = second.next()
fourth = third.next()
fifth = fourth.next()
sixth = fifth.next()

check.expect("First node", repr(first.access()), "a: (1, 1)")
check.expect("Second node", repr(second.access()), "b: (1, 3)")
check.expect("Third node", repr(third.access()), "c: (3, 1)")
check.expect("Fourth node", repr(fourth.access()), "d: (3, 3)")
check.expect("Fifth node", repr(fifth.access()), "e: (1, 1)")
check.expect("Sixth node", repr(sixth.access()), "a: (1, 1)")

print("Tests for x_value")

check.expect("x_value of (1, 1)", first.access().x_value(), 1)
check.expect("x_value of (3, 1)", third.access().x_value(), 3)

print("Tests for y_value")

check.expect("y_value of (1, 1)", first.access().y_value(), 1)
check.expect("y_value of (1, 3)", second.access().y_value(), 3)

print("Tests for label")

check.expect("Label of (1, 1)", first.access().label(), "a")
check.expect("Label of (3, 3)", fourth.access().label(), "d")

print("Tests for same_place")

check.expect("Points in same place", first.access().same_place(fifth.access()), True)
check.expect("Points with same x_value", first.access().same_place(second.access()), False)
check.expect("Points with same y_value", first.access().same_place(third.access()), False)
check.expect("Points with different values", \
             first.access().same_place(fourth.access()), False)

print("Tests for equality")

check.expect("Equal points", first.access() == sixth.access(), True)
check.expect("Not equal points", first.access() == fifth.access(), False)

print("Tests for inequality")

check.expect("Equal points", first.access() != sixth.access(), False)
check.expect("Not equal points", first.access() != fifth.access(), True)

print("Tests for dist")

check.within("Same point", first.access().dist(first.access()), 0.0, .1)
check.within("Same x-values", first.access().dist(second.access()), 2.0, .1)
check.within("Same y-values", first.access().dist(third.access()), 2.0, .1)
check.within("Different values", first.access().dist(fourth.access()), 2.83, .01)


