#include "calculator.h"
#include <iostream>
#include <cstdlib>
using namespace std;

int main( int argc, const char* argv[] ) {

	if ( argc != 2 ) {
		cerr << "usage: " << argv[0] << " <server>" << endl;
		exit(1);
	}

	CLIENT *clnt = clnt_create (argv[1], CALCULATOR, VERSION, "udp");
	if (clnt == NULL) {
		clnt_pcreateerror( argv[1] );
		exit(1);
	}

	for (;;) {
		int a, b;
		int* result;
		char op;
		cin >> a >> op >> b;
		if ( cin.fail() ) break;
		switch (op) {
			case '+': result = add_1( a, b, clnt ); break;
			case '-': result = substract_1( a, b, clnt ); break;
			case '*': result = multiply_1( a, b, clnt ); break;
			case '/': result = divide_1( a, b, clnt ); break;
			default: cerr << op << " unsupported" << endl; continue;
		}
		if ( result == NULL ) {
			clnt_perror (clnt, "call failed");
		} else {
			cout << "result: " << *result << endl;
		}
	}

loopend:
	clnt_destroy(clnt);
	return 0;
}
